#### Overview

- Designed to simplify access policy management.
- Applies uniformly to all interfaces on the ASA.
- Only one global ACL can be configured, containing multiple access rules.

#### Global ACL Configuration

- **Inbound Filtering**: Filters traffic only in an inbound direction.
- **Interface ACL Override**: Interface ACLs are matched before global ACLs.
- **Implicit Deny Rule**: Automatically removed from interface ACLs when a global ACL is present.

#### Order of Access Rule Matching

- **Without Global ACL**:
    - Interface access rules.
    - Default implicit deny-all interface access rule.
- **With Global ACL**:
    - Interface access rules.
    - Bridge Virtual Interface (BVI) access rule (for bridge group member interfaces).
    - Global access rules (if no match is found).
    - Default implicit deny-all global access rule.

#### Benefits of Global ACL

- **Simplified Configuration**: Easier to monitor, edit, or update compared to multiple interface ACLs.
- **Uniform Application**: Applies to all interfaces without specifying each interface.
- **Memory Efficiency**: Saves space as rules are not replicated on each interface.
- **Flexibility**: No need to specify packet ingress interface; focuses on source and destination IPs.
- **Scalability and Performance**: Same architecture as interface ACLs.
- **Ease of Migration**: Simplifies transitioning from other vendor firewalls.

#### Limitations of Global ACL

- **Inbound Only**: Cannot filter outbound traffic; interface ACLs are required for that purpose.
- **Complexity in Large Deployments**: Can become large and unmanageable.
- **Inability to Cover Specific Restrictions**: Sometimes requires more detailed interface-specific rules.
- **Higher Risk of Mistakes**: Deleting the global ACL can have widespread impact.

#### Use Case for Filtering Traffic with Global ACL

- **Scenario**: Internal and external networks need FTP access to a DMZ server, except one internal subnet.
- **Solution**:
    - **Global Rule**: Permit FTP traffic from all networks to the DMZ server.
    - **Interface Rule**: Block FTP traffic from the specific internal subnet to the DMZ server, overriding the global rule.

By using a global ACL, administrators can streamline their firewall configurations, applying consistent security policies across all interfaces. However, for more granular control, especially in complex environments, combining global ACLs with interface-specific ACLs may be necessary.